--[[---------------------------------------------------------------------------
	Chocolatier Two Standard UI Helpers
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Replacement GetString... Use bsgGetString whenever feasible
-- and include [xxxx] variable replacement

local playgroundGetString = GetString
function GetString(key, a, b, c, d, e)
	key = tostring(key)
	
	local s
	local vals
	if not a then
		s = bsgGetString(key)
	elseif type(a) == "table" then
		vals = a
		s = bsgGetString(key)
	else
		s = playgroundGetString(key,a,b,c,d,e)
	end
	
	if s == "#####" then s = key
	else
		s = string.gsub(s, "%[(%w+)%]",
			function(var)
				return (vals and vals[var]) or gSim[var] or "["..var.."]"
			end)
	end
	return s
end

function LabelString(key)
	return "#"..GetString(key)
end

-------------------------------------------------------------------------------
-- TextButton
-- From PG 4.0
-- Create a TButton with a label
function TextButton( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");
			
			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers ) 
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; } 
			);

			table.insert(button,
				Text
				{
					label=LabelString(label),
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags ,
					factory=textfactory,
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end

-------------------------------------------------------------------------------
-- TightText

function TightText(t)
	return function()
		t.label = LabelString(t.label)
		t.w = t.w or ui.screenWidth
		t.h = t.h or ui.screenHeight
		t.typename = "TightText"
		DoWindow(t)
	end
end

-------------------------------------------------------------------------------
-- "Screen" declaration for development with in-game editor space

function bsgScreen(t)
	t.x=0
	t.y=0
	t.w=ui.devScreenWidth
	t.h=ui.devScreenHeight
	if bsgCheckConfig("edit") then
		t.color=Color(192,192,192,255)
		return Rectangle(t)
	else
		return Window(t)
	end
end

-------------------------------------------------------------------------------
-- Ledger helpers

function DialogLedger()
	gDisableBadgeButtons = true
	local r = dofile("ui/ledger.lua")
	gDisableBadgeButtons = nil
	return r
end

function NormalLedger()
	return dofile("ui/ledger.lua")
end

-------------------------------------------------------------------------------
-- Building name banner

function BuildingBanner(building)
	if building and building.name ~= "_travel" then return
		Bitmap { image="ports/banner_location", x=253+ui.xOffset,y=30+ui.yOffset,
			Text { x=0,y=14,w=kMax,h=22, label=LabelString(building.name) }
		}
	end
end

-------------------------------------------------------------------------------
-- Rollover helper

function MakeRollover(t)
	return MakeDialog
	{
		AppendStyle(rolloverStyle),
		Frame { Rectangle(t) }
	}
end

-------------------------------------------------------------------------------
-- Privacy Policy helpers

function PrivacyPolicy()
	if bsgCheckConfig("anonymous") then
		DisplayDialog { "ui/okdialog.lua", body="anonymous_privacy" }
	else
		OpenBrowser("http://www.playfirst.com/privacypolicy.html")
	end
end

-------------------------------------------------------------------------------
-- Help screen helpers

function HelpDialog(num)
	local dialog = "ui/help"..tostring(num)..".lua"
	DisplayDialog{dialog}
end

function HelpTitle(num)
	local t = LabelString("help"..tostring(num).."_title")
	t = t.." ("..tostring(num).."/11)"
	local h = bsgFontHeight(helpTitleFont)
	
	
	local t = LabelString(t)
	
	local g =
	{
		-- TODO: icon
		Text { x=32,y=0,w=kMax,h=h, font=helpTitleFont, flags=kVAlignCenter+kHAlignLeft, label=t }
	}
	
	-- Nav arrows
	local scale=.5
	if (num > 1) then
		local prev = "ui/help"..tostring(num-1)..".lua"
		table.insert(g, Button { x=kMax-32-32-32,y=0, scale=scale, graphics=LeftButtonGraphics, command=function() PopModal("help_dlg") DisplayDialog{prev} end })
	end
	table.insert(g, Button { x=kMax-32-32,y=0, scale=scale, graphics=CloseButtonGraphics, close=true, default=true })
	if (num <11) then
		local next = "ui/help"..tostring(num+1)..".lua"
		table.insert(g, Button { x=kMax-32,y=0, scale=scale, graphics=LeftButtonGraphics, hflip=true, command=function() PopModal("help_dlg") DisplayDialog{next} end })
	end
		
	return Group(g)
end
